// 用canvas的方法画出treeItem的三角
//Create the drop down arrow for the drop down buttons.

qqbrowser.account.onLoginStateChanged.addListener(function(state) {
	accountStateChange(state);
});

// 获取收藏数据的接口
var dataSource = {
	_parse: function(json) {
		if(json === '' || json === '[""]') {
			return [];
		}

		var data = JSON.parse(json),
			bookmarksJson = decodeURIComponent(data[0]),
			bookmarks = JSON.parse(bookmarksJson);

		return bookmarks;
	},
	_getBookmarks: function(method, folderId, callback) {
		var self = this;
		// getTree以及getOfflineTree的方法获取完整的树形结构
		if (method === 'getTree' || method === 'getOfflineTree') {
			qqbrowser.bookmark[method](folderId, function(json) {
				callback(self._parse(json));
			});
			// getChildren以及getOfflineBookmarks获取一层数组结构
		} else {
			qqbrowser.bookmark[method](folderId, 0, function(json) {
				callback(self._parse(json));
			});
		}
	},
	getOfflineBookmarks: function(folderId, callback) {
		this._getBookmarks('getOfflineBookmarks', folderId, callback);
	},
	getChildren: function(folderId, callback) {
		this._getBookmarks('getChildren', folderId, callback);
	},
	getTree: function(folderId, callback) {
		this._getBookmarks('getTree', folderId, callback);
	},
	getOfflineTree: function(folderId, callback) {
		this._getBookmarks('getOfflineTree', folderId, callback);
	}
};

// 声明bmm —— book
var bmm = bmm || {};

//标识被选中的节点，同一时刻只有一个节点可能被选中
var curItem = null;

// 当前选中收藏元素的收藏ID
var curID = null;
var rootID = null;

// 标识多选的item数组
var itemsChosed = {};

// 最后被选中元素，用作shift选择用
var lastChosed = null;


//剪切板
var clipBoard = {};
//标识剪切板状态，0为空，1表示来至剪切，2表示来至复制
var clipBoardFlag = 0;

var treeExpandSet = {};
// 用于记录当前的网络状态
//var isLogon = false;
//var isSyncError = false;
//var isSyncLoading = false;
//var isRetry = false;
bmm.isChange = false;

// 设置当前收藏管理页面的登陆状态
Object.defineProperty(bmm, 'isLogon', (function() {
	var isLogon = false;
	return {
		set : function(state) {isLogon = state; bmm.setRootState(isLogon);},
		get : function() {return isLogon},
		enumerable : true
	}
}()));


bmm.isSyncError = false;
bmm.isSyncLoading = false;
bmm.isRetry = false;
bmm.isUpload = false;

bmm.list = null;
bmm.tree = null;

// 导航区的treeitem只有folder类型
bmm.curTreeID = null;
bmm.curTreeItem = null;

// 内容区的lissitem有folder和url类型
//bmm.curListID = null;

Object.defineProperty(bmm, 'curListID', (function () {
	var id = null;
	return {
		set : function (tempId) { id = tempId; curListIDChange();},
		get : function () { return id; },
		enumerable : true
	};
}()));

bmm.curListItem = null;

bmm.anchorID = null;
bmm.anchorItem = null;

bmm.leadListID = null;
bmm.leadListItem = null;

bmm.rootTreeItem = null;

// 用于标记拖拽时的数据类型;
bmm.overlayType = null;

bmm.menuType = "default";

bmm.multiChose = false;

bmm.dragPrefix = 'x-qqbrowser-bookmarkId-';

bmm.dragData = {};

// 用于标识导入成功
bmm.importSuc = false;

// 用于在新建文件夹，刷新数据之前，应该选中的item
bmm.newChosedItemID = null;


// 用于标记未备份到网络的收藏树的根节点
bmm.offlineRootTreeItem = null;
// 用于标识是否需要显示未备份到网络的收藏树
bmm.isOffline = false;

var importExportType = {
	importTT: 1,
	importLocal : 2,
	exportToLocal: 3,
	importHtml: 4,
	exportHtml: 5
}

// 数据上报使用
var STATIS_FAV_MANAGEPAGE_SEARCH					= 910701;		///< “搜索”使用量					（10701）
var STATIS_FAV_MANAGEPAGE_SORT					= 910702;		///< “按标题排序button”点击量		（10702）
var STATIS_FAV_MANAGEPAGE_DELETE					= 910703;		///< “删除button”点击量				（10703）
var STATIS_FAV_MANAGEPAGE_NEW_FOLDER				= 910704;		///< “新建文件夹”点击量				（10704）
var STATIS_FAV_MANAGEPAGE_IMPORT					= 910705;		///< “导入”点击量					（10705）
var STATIS_FAV_MANAGEPAGE_EXPORT					= 910706;		///< “导出”点击量					（10706）
var STATIS_FAV_MANAGEPAGE_DOWNLOAD				= 910707;		///< “登陆态使用下载到本地”的点击量	（10707）
var STATIS_FAV_MANAGEPAGE_UPLOAD					= 910708;		///< “非登陆态上传到网络”的点击量		（10708）

function accountStateChange(state) {
	if (state === 1) {
		bmm.isLogon = false;
	// 登陆状态
	} else if (state === 2) {
		bmm.isLogon = true;
	// 离线状态—伪登陆状态
	} else if (state === 3) {
		bmm.isLogon = true;
	}

	// 根据登录状态设置菜单的wording
	if (bmm.isLogon) {
		qqbrowser.account.getCurrent(function(accountData) {
			userInfo = JSON.parse(accountData)[0];
			if (typeof userInfo.nUin === "number" && userInfo.nUin !== 0) {
				menuManager.setSyncWording(userInfo.strNickName);
			}
		});
	} else {
		menuManager.setSyncWording('未登录');
	}
}


/**
 * 当右侧
 */
function curListIDChange() {
	// 若此时右侧区域是未备份收藏的状态，那么不允许改变编辑'、'删除'按钮的状态
	if (bmm.isOffline) {
		return;
	}
	
	var editButton = getId("edit");
	var deleteButton = getId("deleteButton");

	if (bmm.curListItem === null) {
		editButton.addClass('disabled');
		// deleteButton.addClass('disabled');
	} else {
		editButton.removeClass('disabled');
		// deleteButton.removeClass('disabled');
	}
	
	if (isEmptyObject(itemsChosed) === true) {
		deleteButton.addClass('disabled');
	} else {
		deleteButton.removeClass('disabled');
	}
};

bmm.init = function() {
	// 注册账号登录的listener
	qqbrowser.account.onLogin.addListener(function(windowId, uin, strUin, nickName, facePath) {
		if (uin !== 0) {
			bmm.isLogon = true;
		} else {
			bmm.isLogon = false;
		}
	});

	qqbrowser.account.getLoginState(function(state) {
		state = JSON.parse(state)[0];
		accountStateChange(Number(state));
	});

	// 禁止网页自身的右键行为
	document.oncontextmenu = function() {
		return false;
	};


	// 绑定标题栏按钮的功能
	bmm.hBtnFuncBind();
	// 获取后台数据后建立收藏树
	browser.bookmark.getTree(bmm.buildTree);
	bmm.buildList();


	// 绑定右键菜单的功能
	bmm.menuFuncBind();

	// 绑定菜单按钮的功能
	menuManager.init();


	browser.bookmark.getSyncState(bmm.getSyncState);
	browser.bookmark.onSyncStateChanged.addListener(bmm.getSyncState);

	// 绑定相应的查找功能
	bmm.searchFuncBind();


	// 拖拽功能的全局设置
	document.ondragover = function(e) {
		var dt = e.dataTransfer;
		dt.dropEffect = "none";

		e.preventDefault();
	};

	document.ondrop = function(e) {
		e.preventDefault();
	};

	headerMenuFunc();

	// 一旦收藏数据变化就重新刷新收藏管理页面
	qqbrowser.bookmark.onBookmarkChanged.addListener(function(ret){
		if (bmm.isChange) {
			bmm.isChange = false;
		} else {
			browser.bookmark.getTree(bmm.buildTree);
		}
	}) ;
};

hideAllHeaderMenu = function() {
	menuManager.newHandle.hide();
	menuManager.sortHandle.hide();
	menuManager.moreHandle.hide();
};

/**
 * 关闭所有顶部操作的菜单
 */
headerMenuFunc = function() {
	// 新建菜单
	menuManager.newHandle.items[0]._element.addEventListener("click", function() {
		var command = {
			command: 'showAddFav',
			favID: parseInt(bmm.curTreeID, 10),
			isNew: 1
		};
		qqbrowser.extension.sendRequest('{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}', command, function() {});
		hideAllHeaderMenu();
	}, false);

	menuManager.newHandle.items[1]._element.addEventListener("click", function() {
		bmm.newFolderFunc();
		hideAllHeaderMenu();
	}, false);

	// 排序菜单
	menuManager.sortHandle.items[0]._element.addEventListener("click", function() {
		if (bmm.curTreeItem) { // 排序后需要重新刷新一次页面数据，否则导航区与内容区显示不同步，会造成导航区已有文件夹展开状态丢失
			qqbrowser.bookmark.sort(parseInt(bmm.curTreeID),"title", bmm.sort);
		}
		hideAllHeaderMenu();
	}, false);

	menuManager.sortHandle.items[1]._element.addEventListener("click", function() {
		if (bmm.curTreeItem) { // 排序后需要重新刷新一次页面数据，否则导航区与内容区显示不同步，会造成导航区已有文件夹展开状态丢失

			qqbrowser.bookmark.sort(parseInt(bmm.curTreeID),"visits", bmm.sort);
		}
		hideAllHeaderMenu();
	}, false);

	menuManager.sortHandle.items[2]._element.addEventListener("click", function() {
		if (bmm.curTreeItem) { // 排序后需要重新刷新一次页面数据，否则导航区与内容区显示不同步，会造成导航区已有文件夹展开状态丢失
			qqbrowser.bookmark.sort(parseInt(bmm.curTreeID),"modified", bmm.sort);
		}
		hideAllHeaderMenu();
	}, false);

	// 导入和导出菜单
	menuManager.moreHandle.items[0]._element.addEventListener("click", function() {
		qqbrowser.extension.sendRequest('{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}', {command: 'showImportFav'}, function() {});

		hideAllHeaderMenu();
		event.stopPropagation();
	}, false);

	menuManager.moreHandle.items[1]._element.addEventListener("click", function() {
		qqbrowser.bookmark.importExportBookmark(importExportType['importHtml']);

		hideAllHeaderMenu();
		event.stopPropagation();
	}, false);

	menuManager.moreHandle.items[2]._element.addEventListener("click", function() {
		qqbrowser.bookmark.importExportBookmark(importExportType['importTT']);

		hideAllHeaderMenu();
		event.stopPropagation();
	}, false);

	menuManager.moreHandle.items[3]._element.addEventListener("click", function() {
		qqbrowser.extension.sendRequest('{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}', {command: 'showExportFav'}, function() {});

		hideAllHeaderMenu();
		event.stopPropagation();
	}, false);

	menuManager.moreHandle.items[4]._element.addEventListener("click", function() {
		qqbrowser.bookmark.importExportBookmark(importExportType['importLocal']);

		hideAllHeaderMenu();
		event.stopPropagation();
	}, false);

	menuManager.moreHandle.items[5]._element.addEventListener("click", function() {
		qqbrowser.bookmark.importExportBookmark(importExportType['exportToLocal']);

		hideAllHeaderMenu();
		event.stopPropagation();
	}, false);


}

/**
 * 获取后台数据后建立收藏树
 * 主要是建树的根节点，区别本地收藏树以及网络收藏树
 * @param data 符合树结构JSON串——可转为树结构数组
 */
bmm.buildTree = function(data) {
	var returnObject = JSON.parse(data);
	var unescapedData = unescape(returnObject[0]);
	var favObject = JSON.parse(unescapedData);

	var content = favObject[0].children;

	rootID = favObject[0].children[0].id;
	//console.info(rootID);

	// 初始化生成树所需的容器
	var treeContainer = bmm.getTreeContainer();

	treeContainer.addEventListener("dragover", function(event) {
		if (event.target === event.currentTarget) {
			bmm.overlayType = 'below';

			var rootChildren = bmm.rootTreeItem._treeChildren.children;
			var length = rootChildren.length;
			var rect;

			if (length) {
				var dropPos = "below";

				var lastElement = rootChildren[length - 1];
				var lastItem = lastElement.treeitem;
				rect = lastElement.getBoundingClientRect();

				var labelElement = lastItem.treeLabel;
				var labelRect = labelElement.getBoundingClientRect();
				rect = cloneClientRect(rect);

				rect.left = labelRect.left;
				rect.width -= rect.left;
			} else {
				// If there are no items, collapse the height of the rect
				rect = cloneClientRect(rect);
				rect.height = 0;
				// We do not use bottom so we don't care to adjust it.
			}

			// 为了避免多次出现，先暂时严禁这里的显示
			// bmm.showDropOverlay(rect, bmm.overlayType);
		}

		event.preventDefault();
		event.stopPropagation();
	});

	treeContainer.addEventListener('dragleave', function(event) {
		bmm.hideDropOverlay();
		return false;
	}, false);

	treeContainer.addEventListener("drop", function(event) {
		if (event.target === event.currentTarget) {
			var dt = event.dataTransfer;
			var id = dt.getData("text/plain");
			id = id.indexOf(bmm.dragPrefix) !== -1 ? id.replace(bmm.dragPrefix, '') : id;

			var rootChildren = bmm.rootTreeItem._treeChildren.children;
			var length = rootChildren.length;
			var lastElement = rootChildren[length - 1];
			var lastItem = lastElement.treeitem;


			var index = lastItem.index + 1;
			if (bmm.overlayType === "below") {
				bmm.dropMove(id, bmm.rootTreeItem.id, index);
			} else {
				bmm.hideDropOverlay();
				return false;
			}
			bmm.overlayType = null;
			bmm.hideDropOverlay();

		}

		bmm.hideDropOverlay();
		event.preventDefault();
		event.stopPropagation();
	});

	dataSource.getOfflineTree(0, function(offlineBookmarks) {
		// 将重新构建树的过程放到getOfflineTree的回调函数中
		treeContainer.innerHTML = '';
		bmm.tree = document.createElement("tree");

		//属性设置
		bmm.tree.id = "tree";
		bmm.tree.setAttribute("tabIndex", "2");
		bmm.tree.setAttribute("role", "tree");
		bmm.tree.setAttribute("contextmenu", "#context-menu");
		treeContainer.appendChild(bmm.tree);

		bmm.buildSubTree(bmm.tree, content, 0);
		bmm.rootTreeItem = bmm.tree.firstChild.treeitem;

		// 此时判断是否有未备份的数据
		if (offlineBookmarks.length === 0) {
			bmm.isOffline = false;
		} else {
			bmm.isOffline = true;
			offlineInfo = {
				draggable: false
			}
			bmm.buildSubTree(bmm.tree, offlineBookmarks[0].children, 0, undefined, offlineInfo);
			bmm.offlineRootTreeItem = bmm.tree.firstChild.nextSibling.treeitem;
			bmm.offlineRootTreeItem.setTitle("未备份到网络的收藏");

			bmm.offlineRootTreeItem._element.style.marginTop = '20px';
		}

		// 导入成功之后的视觉调整
		if (bmm.importSuc) {
			bmm.importSuc = false;
			bmm.importSucFunc();
		}

		if (bmm.isOffline) {
			bmm.backupFunc('online');
		}

		bmm.rootTreeItem.setDraggable(false);
		
		bmm.isOriginalFav = returnObject[2];
		if(bmm.isOriginalFav) {
			// 引入收藏面板出现
			bmm.openRoot();
		} else {
			bmm.openRoot();
		}
		
		bmm.setRootState(bmm.isLogon, 1);

		//生成树之后一些必要的事件处理
		bmm.dragScrollFuncBind(document.getElementById('folder-tree'));
	});
};

bmm.setRootState = function(isLogon, flag) {
	if (typeof isLogon === 'undefined' )
		return;
	try {
		if (bmm.rootTreeItem) {
			if (isLogon) {
				bmm.rootTreeItem.treeLabel.addClass("online");
				bmm.rootTreeItem.setTitle("网络收藏");
			} else {
				bmm.rootTreeItem.treeLabel.removeClass("online");
				bmm.rootTreeItem.setTitle("本地收藏");
				// Modified by littleli
				// 暂时屏蔽入口
				// 未登录时，显示‘备份到网络’按钮
				// bmm.backupFunc('offline');
			}
		}

		if (!flag) {
			// 登录以及退出登录时清空当前选中的目录状态
			if (bmm.curTreeItem && bmm.curTreeItem !== bmm.rootTreeItem ) {
				bmm.curTreeID = null;
				bmm.curTreeItem = null;
			}

			// 只有当rootTreeItem不为空的时候才能打开Root
			if (bmm.rootTreeItem) {
				bmm.openRoot();
			}
		}


	} catch(e) {
		console.info(e);
	}
};

/**
 * 导入成功显示处理函数
 */
bmm.importSucFunc = function() {
	if (bmm.rootTreeItem) {
		var importSuc = document.createElement('div');
		importSuc.setAttribute('id', 'import-suc');
		importSuc.innerText = '备份完成';

		bmm.tree.appendChild(importSuc);

		setTimeout(function() {
			importSuc.style.display = 'none';
		}, 3000);
	}
}

/**
 * 未备份到网络收藏的功能
 * @param type 表示为哪一类按钮
 */
bmm.backupFunc = function(type) {
	var typeToContent = {
		offline:
		{
			title: '备份到网络',
			element: bmm.rootTreeItem ? bmm.rootTreeItem : undefined
		},
		online:
		{
			title: '立即备份',
			element: bmm.offlineRootTreeItem ? bmm.offlineRootTreeItem : undefined
		}
	};
	var backupButton = document.createElement('button');
	backupButton.setAttribute('id', 'backup-button');

	var title = typeToContent[type]['title'];
	var appendElement = typeToContent[type]['element'];

	if (appendElement) {
		backupButton.innerText = title;
		appendElement._treeRow.appendChild(backupButton);
	}

	backupButton.addEventListener('click', function() {
		if (type === 'online') {
			// Modified by littleli
			// 点击'立即备份'按钮后，如果此时选中的是未备份的数据，
			// 那么将其清空，选中项变为根节点
			if (bmm.curTreeID.indexOf('offline') > -1) {
				bmm.curTreeID = null;
				bmm.curTreeItem = null;
			}
			qqbrowser.bookmark.import(6, '', 0, function(result) {
				result = JSON.parse(result);
				// 导入成功
				if(result[0] === 1) {
					bmm.importSuc = true;
					// 导入失败
				} else {
				}
			});
		} else {
			// 需要登录的导入/导出api调用
			qqbrowser.bookmark.importExportBookmark(importExportType['importLocal']);
		}
		event.stopPropagation();
	}, false);
};

bmm.openRoot = function() {
	// 初始状态展开根节点
	if (bmm.curTreeID) {
		bmm.curTreeItem = getId(bmm.curTreeID).treeitem;
		bmm.curTreeItem.setSelected(true);
		//bmm.curTreeItem.showSubTree();
		bmm.flushList(bmm.curTreeID);
	} else {
		bmm.rootTreeItem.setSelected(true);
		bmm.rootTreeItem.showSubTree();
		bmm.flushList(bmm.rootTreeItem.id);

		bmm.curTreeItem = bmm.rootTreeItem;
		bmm.curTreeID = bmm.rootTreeItem.id;
	}

	treeExpandSet[bmm.rootTreeItem.id] = bmm.rootTreeItem;
};

function cloneClientRect(rect) {
	var newRect = {};
	for (var key in rect) {
		newRect[key] = rect[key];
	}
	return newRect;
};

bmm.buildTreeItem = function(id, rootTreeItem, layer, title, isTop) {
	var treeItem = new qqbrowser.js.widgets.treeItem(id, rootTreeItem, layer, isTop);

	// 设置treeItem的title
	treeItem.setTitle(title);
	treeItem.setDraggable(true);

	// 事件绑定
	treeItem.onItemClick(function(event, treeItem) {

		hideAllHeaderMenu();

		menuManager.contexMenu.hide();
		if (treeItem !== bmm.curTreeItem) {
			if (bmm.curTreeItem) {
				// 使原来选中的项变为非选中状态
				bmm.curTreeItem.setSelected(false);
			}
			bmm.curTreeID = this.id;
			bmm.curTreeItem = treeItem;

			treeItem.setSelected(true);

			bmm.flushList(treeItem.id);
		}
	});

	treeItem.onItemContextMenu(function(event, treeItem) {
		hideAllHeaderMenu();

		if (treeItem !== bmm.curTreeItem) {
			if (bmm.curTreeItem) {
				// 使原来选中的项变为非选中状态
				bmm.curTreeItem.setSelected(false);
			}
			bmm.curTreeID = treeItem.id;

			bmm.curTreeItem = treeItem;
			treeItem.setSelected(true);
		}

		bmm.flushList(treeItem.id);

		if (treeItem.id.indexOf('offline-') !== -1) {
			menuManager.contexMenu.hide();
			return;
		}

		bmm.menuType = "nav";

		menuManager.folderContextMenu(treeItem);
	});

	treeItem.onEditEnd(function(treeItem) {
		bmm.isChange = true;
		qqbrowser.bookmark.renameFolder(parseInt(treeItem.id), treeItem.title, function(returnData) {
			var returnObject = JSON.parse(returnData);
			var errorCode=returnObject[0];
			if(errorCode == 1) {
				// TODO 之后需要好好验证
				treeItem.setTitle(treeItem.title);
				browser.bookmark.getTree(bmm.buildTree);
			}
			else if(errorCode == -2) {
				bmm.isChange = false;
				alert("同名文件夹已存在，请重新命名");
				treeItem.title = treeItem.oldTitle;
				treeItem.setTitle(treeItem.title);
			}
		});
	});

	treeItem._treeRow.addEventListener("dragstart", function(event) {

		var dt = event.dataTransfer;

		dt.setData("text/plain", bmm.dragPrefix + this.parentNode.id);

		bmm.dragData.isTree = true;

		event.stopPropagation();
	}, false);

	treeItem._treeRow.addEventListener("dragover", function(event) {

		var dt = event.dataTransfer;
		var id= dt.getData("text/plain");
		id = id.indexOf(bmm.dragPrefix) !== -1 ? id.replace(bmm.dragPrefix, '') : id;

		var overItem = this.parentNode.treeitem;
		var overElement = this;


		// 如果over的元素为未备份数据元素，那么严禁拖拽到此
		// dragover事件中严禁调用hideDropOverlay()方法
		if (overItem.id.indexOf('offline-') !== -1) {
			dt.dropEffect = 'none';
			event.stopPropagation();
			return;
		}
		this.parentNode.addClass("hover");

		// 标识哪种拖拽释放的类型
		var dropPos;

		var rect;

		rect = this.getBoundingClientRect();

		// 处理从其中区域拖拽至左侧导航区目录结构时，
		// 不应该显示定位线，只应该显示是否能拖拽至此文件夹
		if (!(bmm.dragData && bmm.dragData.isTree)) {
			if (overItem.id === id) {
				dt.dropEffect = "none";
			}
			dropPos = "on";

			bmm.overlayType = dropPos;
			bmm.showDropOverlay(rect, bmm.overlayType);
			event.preventDefault();
			event.stopPropagation();
			return;
		}

		var dy = event.clientY - rect.top;
		var yRatio = dy / rect.height;

		if (yRatio < .25 && overItem.id !== bmm.rootTreeItem.id) { // 上面25%响应为插入上方
			dropPos = "above";
			this.parentNode.removeClass("hover");
		} else if (yRatio > .75 && overItem.id !== bmm.rootTreeItem.id && !overItem.expanded) { // 下面25%响应为插入下方
			dropPos = "below";
			this.parentNode.removeClass("hover");
		} else { // 中间50%响应为插入到文件夹内部
			if (overItem.id === id || overItem.id === bmm.rootTreeItem.id) {
				dt.dropEffect = "none";
			}
			dropPos = "on";
		}

		// 导航区树结构长度的特殊计算
		if (dropPos === 'above' || dropPos == 'below') {
			// ClientRect is read only so clone in into a read-write object.
			rect = cloneClientRect(rect);

			var labelElement = overItem.treeLabel;
			var labelRect = labelElement.getBoundingClientRect();

			rect.left = labelRect.left;
			rect.width -= rect.left;
			//rect.width = parseInt(rect.width * 1.5, 10);
		}

		bmm.overlayType = dropPos;

		bmm.showDropOverlay(rect, bmm.overlayType);

		event.preventDefault();
		//event.stopPropagation();
	}, false);

	treeItem._treeRow.addEventListener("dragleave", function(event) {
		var treeitem = this.parentNode.treeitem;

		this.parentNode.removeClass("hover");
		bmm.hideDropOverlay();

		event.preventDefault();
		event.stopPropagation();
	}, false);


	/**
	 * 拖到item里面时使用
	 */
	treeItem._treeRow.addEventListener("drop", function(event) {

		this.parentNode.removeClass("hover");

		var dt = event.dataTransfer;
		var id= dt.getData("text/plain");
		id = id.indexOf(bmm.dragPrefix) !== -1 ? id.replace(bmm.dragPrefix, '') : id;

		var dropId = this.parentNode.id;
		// 如果over的元素为未备份数据元素，那么严禁拖拽到此
		if (dropId.indexOf('offline-') !== -1) {
			dt.dropEffect = 'none';
			bmm.hideDropOverlay();
			return;
		}


		var dropItem = this.parentNode.treeitem;
		// 如果是
		var parentItem = dropItem._root;

		var index = dropItem.index;

		var itemsChosedCount = 0;

		if (bmm.overlayType === "on") { // 放置到该listItem中
			bmm.dropMove(id, dropId, 0);
			treeExpandSet[this.parentNode.id] = this.parentNode.treeitem;
		} else if (bmm.overlayType === "above") { // 放置到该listItem之上
			bmm.dropMove(id, parentItem.id, index);
		} else if (bmm.overlayType === "below") { // 放置到该listeItem之下
			++index;
			bmm.dropMove(id, parentItem.id, index);
		} else { // 错误处理
			return false;
		}

		// 还原该标识
		bmm.overlayType = null;
		bmm.hideDropOverlay();

		event.preventDefault();
		event.stopPropagation();
	}, false);

	treeItem.onItemExpand(function(treeItem) {
		treeExpandSet[treeItem.id] = treeItem;
	});

	treeItem.onItemFold(function(treeItem) {
		delete treeExpandSet[treeItem.id];
	});

	return treeItem;
};

// 用于数据改动之前树展开状态的数据结构
var treeExpandSetTmp = {};

/**
 * 真正完成建树过程的函数，里面存在递归建树的过程
 * @param rootTreeItem 构建子树的根节点
 * @param content 构建树的数据（符合树结构的数据）
 * @param layer 当前节点的层次
 * @param depth 当前节点的深度
 * @param offlineInfo
 */
bmm.buildSubTree = function(rootTreeItem, content, layer, depth, offlineInfo) {
	if (depth === undefined) {
		depth = 0;
	}
	// 如果该文件夹只有url没有folder那么mayhaveChildren为true
	if (content.length > 0) {
		rootTreeItem.mayhaveChildren = true;
	}
	//console.info(content);
	for (var i = 0; i < content.length; i++) {
		var thisResult = content[i];
		// 构建导航区树的时候只处理文件夹的部分
		if (thisResult.type === "url") {
			// 在构建左侧目录区时，如果该文件夹有url类型的子节点的话，那么右键菜单的1、2项才可以使用
			rootTreeItem.hasUrlChildren = true;
		} else {
			// 如果此时为未备份的数据，那么id加上前缀
			var id = offlineInfo ? 'offline-' + thisResult.id : thisResult.id;
			var treeItem = bmm.buildTreeItem(id, rootTreeItem, layer, thisResult.title);
			(offlineInfo && treeItem.setDraggable(offlineInfo.draggable));

			treeItem.index = i;

			if (thisResult.children !== []) { // 递归创建子树
				bmm.buildSubTree(treeItem, thisResult.children, layer + 1, depth + 1, offlineInfo);

			}

			if (treeExpandSet[treeItem.id] !== undefined) {
				// 如果该treeitem确定有子节点才需要展开
				if (treeItem.hasChildren) {
					treeExpandSetTmp[treeItem.id] = treeItem;
					treeItem.showSubTree();
				}
			}
		}
	}

	if (depth === 0 && offlineInfo === undefined) {
		treeExpandSet = treeExpandSetTmp;
		treeExpandSetTmp = {};
	}
};

/**
 * 构建内容区的list容器
 */
bmm.buildList = function() {
	var listContainer = getId("layer-list");

	bmm.list = new qqbrowser.js.widgets.list("list", listContainer);
	bmm.list._element.setAttribute('role', 'list');

	bmm.list._element.addEventListener("click", function() {

		if ( event.target && event.target.listitem ) {
			return false;
		} else {
			bmm.list.setAllListReset(); // 清空表现的状态

			// 清空数据维护的状态
			bmm.curListItem = null;
			bmm.curListID = null;

			// 这种状态下要清空多选数组
			itemsChosed = {};
			curListIDChange();
		}

		//event.stopPropagation();
	}, false);

	bmm.list._element.addEventListener("dragover", function(event){
		if (bmm.isSearch) {
			event.dataTransfer.dropEffect = 'none';
			return;
		}

		if (event.target.id === "list") {

			// 如果此时右侧内容区的内容属于‘未备份到网络’的虚拟收藏信息，那么显示禁止拖拽
			if (bmm.list._element.firstChild === undefined
				|| (bmm.list._element.firstChild.listitem && bmm.list._element.firstChild.listitem.offline)) {
				event.dataTransfer.dropEffect = 'none';
				event.stopPropagation();
				return false;
			}

			bmm.overlayType = 'below';
			var length = this.children.length;
			var rect;

			if (length) {
				var dropPos = "below";
				lastElement = this.children[length - 1];
				rect = lastElement.getBoundingClientRect();
			} else {
				// If there are no items, collapse the height of the rect
				rect = cloneClientRect(rect);
				rect.height = 0;
				// We do not use bottom so we don't care to adjust it.
			}

			bmm.showDropOverlay(rect, bmm.overlayType);
		}

		event.preventDefault();
		event.stopPropagation();
	}, false);

	bmm.list._element.addEventListener("drop", function(event){
		var dt = event.dataTransfer;
		var id = dt.getData("text/plain");
		id = id.indexOf(bmm.dragPrefix) !== -1 ? id.replace(bmm.dragPrefix, '') : id;

		var index = this.children.length;
		if (bmm.overlayType === "below") {
			bmm.dropMove(id, bmm.curTreeID, index);
		} else {
			bmm.hideDropOverlay();
			return false;
		}


		bmm.overlayType = null;
		bmm.hideDropOverlay();
		event.preventDefault();
		event.stopPropagation();
	}, false);


	bmm.dragScrollFuncBind(bmm.list._element);

};

/**
 * 根据信息生成一个list节点
 * @param id
 * @param title
 * @param type
 * @param url
 * @param faviconPath
 * @param isTop
 * @returns {___listItem0}
 */
bmm.buildListItem = function(id, title, type, url ,faviconPath, isTop) {

	var listItem = new qqbrowser.js.widgets.listItem(id, type);

	// 设置treeItem的title
	listItem.setTitle(title);


	if (type === "url") {

		if (url) {
			listItem.setUrl(url);
		}
		if (faviconPath) {
			listItem.setIcon(faviconPath);
		} else {
			listItem.setIcon("../aero/images/favlist/FavBar_Item.png");
		}

		listItem.iconElement.onerror = function() {
			this.src = "../aero/images/favlist/FavBar_Item.png";
		};
	}

	// 插入list窗口的顶部
	if (isTop && bmm.list._element.firstChild) {
		bmm.list._element.insertBefore(listItem._element, bmm.list._element.firstChild);
	} else {
		listItem.insert(bmm.list._element);
	}


	// 事件绑定
	listItem.onItemClick(function(event, listItem) {
		hideAllHeaderMenu();
		menuManager.contexMenu.hide();
		
		// Modified by littleli
		// 用于标识多选的变量
		bmm.leadListItem = listItem;
		bmm.leadListID = listItem.id;
		
		if (bmm.multiChose === 1) { // 判断多选的标识位 ctrl
			if (bmm.curListItem !== null && itemsChosed[bmm.curListItem.id] === undefined) {
				itemsChosed[bmm.curListItem.id] = bmm.curListItem;
				curListIDChange();
			}
			bmm.curListItem = null;
			bmm.curListID = null;

			if (!listItem.multiSelected) { // 之前未选中的此时进入选中状态
				listItem.multiSelected = true;
				listItem.setSelected(true);
				if (itemsChosed[listItem.id] === undefined) {
					itemsChosed[listItem.id] = listItem;
					curListIDChange();
				}
			} else { // 之前选中的此时进入未选中状态
				listItem.multiSelected = false;
				listItem.setSelected(false);
				// 去掉刚才选中元素
				delete itemsChosed[listItem.id];
				curListIDChange();
			}

			lastChosed = listItem;
		} else if (bmm.multiChose === 2) {	//shift
			// modified by littleli
			// 用shift多选时也应该清除当前选定的ListItem项
			bmm.curListItem = null;
			bmm.curListID = null;

			var listChildren = bmm.list._element.children;
			var listLen = listChildren.length;
			var item;
			var isShiftChose = 0;
			for (var i = 0; i <listLen; ++i ) {
				item = listChildren[i].listitem;
				if (item === undefined) {
					continue;
				}
				if (lastChosed === listItem) {
					break;
				}
				if (lastChosed && (item === lastChosed || item === listItem)) {
					++isShiftChose;
				}
				if (isShiftChose === 1) {	// 选
					item.setSelected(true);
					item.multiSelected = true;
					if (itemsChosed[item.id] === undefined) {
						itemsChosed[item.id] = item;
						curListIDChange();
					}
				} else if (isShiftChose === 2) {
					item.setSelected(true);
					item.multiSelected = true;
					if (itemsChosed[item.id] === undefined) {
						itemsChosed[item.id] = item;
						curListIDChange();
					}
					++isShiftChose;
				} else {	//不选
					item.setSelected(false);
					if (itemsChosed[item.id] !== undefined) {
						delete itemsChosed[item.id];
						curListIDChange();
					}
				}
			}
			lastChosed = listItem;
		} else {	//不按键点
			if (listItem !== bmm.curListItem) {

				bmm.list.setAllListReset();
				bmm.curListID = this.id;
				bmm.curListItem = listItem;

				bmm.leadListID = this.id;
				bmm.leadListItem = listItem;

				// 这种状态下要清空多选数组
				itemsChosed = {};

				// TODO
				// 单选时不进入itemsChosed结构，由于多选拖拽只依赖于itemsChosed结构而单选拖拽时并没有选中一个listItem
				itemsChosed[listItem.id] = listItem;
				curListIDChange();

				listItem.setSelected(true);
				listItem.setLead(true);

				lastChosed = listItem;
			}
			
			bmm.anchorItem = listItem;
			bmm.anchorID = listItem.id;
		}

		//alert(lastChosed.title);
	});

	// 在双击之前必然会经历单击的选中过程，所以可以不重复执行样式调整的工作
	listItem.onItemDblClick(function(event, listItem) {
		if (listItem.type === "folder") {

			bmm.flushList(listItem.id);

			// edit by littleli
			// 由于拖拽时需要用到itemsChosed里面的内容
			// 双击时清空itemsChosed结构
			// 避免出现内容区双击进入文件夹后读取原来错误itemsChosed的内容
			itemsChosed = {};
			curListIDChange();

			var treeItem = listItem.treeitem;

			if (treeItem !== bmm.curTreeItem) {
				//console.info(bmm.curTreeItem);
				bmm.curTreeItem.setSelected(false);
				bmm.curTreeItem = treeItem;
				bmm.curTreeID = treeItem.id;
				treeItem.setSelected(true);
			}

			var temp = treeItem;

			// 依次打开该文件夹所在的父节点元素
			if (treeItem) {
				while(temp._root instanceof qqbrowser.js.widgets.treeItem) {
					temp._root.showSubTree();
					temp = temp._root;
				}
			}
		} else {
			try{
				    qqbrowser.bookmark.popupNavigate(parseInt(listItem.id));
			}catch(err){
			}
			qqbrowser.tabs.create(listItem.url, 2);
		}

	});

	listItem.onItemContextMenu(function(event, listItem) {
		// 如果是离线的虚拟收藏数据那么数据操作
		if (listItem.offline) {
			return;
		}

		hideAllHeaderMenu();

		if (listItem !== bmm.curListItem) {
			if (itemsChosed[listItem.id] === undefined) {
				bmm.list.setAllListReset();
				bmm.curListID = this.id;
				bmm.curListItem = listItem;

				bmm.leadListID = this.id;
				bmm.leadListItem = listItem;

				// 这种状态下要清空多选数组
				itemsChosed = {};
				itemsChosed[listItem.id] = listItem;
				curListIDChange();

				listItem.setSelected(true);
				listItem.setLead(true);
			} else { // 如果不在多选列表中，那么将其选中
				// Modified by littleli
				// 解决多选时'编辑'按钮不灰显的问题
				//bmm.curListID = this.id;
				bmm.curListItem = listItem;
			}
		} else {
			if (listItem.id in itemsChosed) {

			} else {
				// 这种状态下要清空多选数组
				itemsChosed = {};
				itemsChosed[listItem.id] = listItem;
				curListIDChange();
			}
		}

		bmm.menuType = "content";
		
		// 判断当前选中项的数目
		var itemsChosedLength = 0;
		for (var id in itemsChosed) {
			++itemsChosedLength;
		}
		
		if (itemsChosedLength > 1) {
			menuManager.folderContextMenu(menuManager);
			return;
		}
		
		if (listItem.type === "folder") {
			menuManager.folderContextMenu(menuManager);
		} else {
			menuManager.urlContextMenu(menuManager);
		}
	});

	listItem.onEditEnd(function(listItem) {
		if (listItem.type === "url") {
			bmm.isChange = true;
			qqbrowser.bookmark.update(-1, parseInt(listItem.id), listItem.title, listItem.url, function() {
			});
		} else {
			bmm.isChange = true;
			qqbrowser.bookmark.renameFolder(parseInt(listItem.id), listItem.title, function(returnData) {
				var returnObject = JSON.parse(returnData);
				var errorCode=returnObject[0];
				if (errorCode == 1) {
					// TODO 之后需要好好验证
					listItem.setTitle(listItem.title);
					listItem.treeitem.setTitle(listItem.title);
					browser.bookmark.getTree(bmm.buildTree);
					// 重命名时也记录应该被选中的文件夹
					bmm.newChosedItemID = listItem.id;
				} else if(errorCode == -2) {
					alert("同名文件夹已存在，请重新命名");
					bmm.isChange = false;
					listItem.title = listItem.oldTitle;
					listItem.setTitle(listItem.title);
				}
			});
		}
	});

	listItem.onCloseButtonClick(function(event, listItem) {
		var result = confirm("确定要删除选中的项目？");
		if (result) {
			// 删除时选解除全局引用
			if (listItem === bmm.curListItem) {
				bmm.curListItem = null;
				bmm.curListID = null;
			}
			if (listItem.type === "folder") {

				var oldRoot = listItem.treeitem._root;

				// 同步导航区的显示
				if (listItem.treeitem === bmm.curTreeItem) {
					bmm.curTreeID = null;
					bmm.curTreeItem = null;
				}

				//listItem.treeitem.remove();
				qqbrowser.bookmark.removeTree(parseInt(listItem.id));

			} else { // 删除具体的链接不需要同步导航区的内容
				qqbrowser.bookmark.remove(parseInt(listItem.id));

			}
		} else {
			listItem.setSelected(true);
		}
	});

	listItem._element.addEventListener("dragstart", function(event) {
		var dragItem = this.listitem;

		if (!(dragItem.id in itemsChosed)) {
			// 清除选中元素的样式
			for (item in itemsChosed) {
				itemsChosed[item].setSelected(false);
			}
			// 清空选中元素数据结构
			itemsChosed = {};
			itemsChosed[dragItem.id] = dragItem;
			curListIDChange();
		}

		var dt = event.dataTransfer;
		dt.effectAllowed = "move";

		dt.setData("text/plain",  bmm.dragPrefix + this.id);

	}, false);

	listItem._element.addEventListener("dragover", function(event) {
		if (bmm.isSearch) {
			event.dataTransfer.dropEffect = 'none';
			return;
		}
		var dt = event.dataTransfer;
		var id = dt.getData("text/plain");
		id = id.indexOf(bmm.dragPrefix) !== -1 ? id.replace(bmm.dragPrefix, '') : id;

		var overItem = this.listitem;

		// 加入‘未备份到网络的收藏’内容的处理
		if (overItem.offline) {
			dt.dropEffect = 'none';
			event.preventDefault();
			event.stopPropagation();
			return false;
		}

		if (this.listitem.type !== "url") {
			this.addClass("hover");
		}

		var dropPos;

		var rect;

		rect = this.getBoundingClientRect();

		var dy = event.clientY - rect.top;
		var yRatio = dy / rect.height;

		if (yRatio < .25) {
			dropPos = "above";
			this.removeClass("hover");
		} else if (yRatio > .75) {
			dropPos = "below";
			this.removeClass("hover");
		} else {
			if (this.id === id || "url" === this.listitem.type) {
				dt.dropEffect = "none";
			}
			dropPos = "on";
		}

		bmm.overlayType = dropPos;

		bmm.showDropOverlay(rect, bmm.overlayType);

		//event.stopPropagation();
		event.preventDefault();
	}, false);

	listItem._element.addEventListener("dragleave", function(event) {
		// 如果此时为虚拟数据，那么不用再调用hideDropOverlay()
		// 多次调用hideDropOverlay()会导致定位线不消失
		if (event.target.listitem && event.target.listitem.offline) {
			event.preventDefault();
			event.stopPropagation();
			return false;
		} else {
			bmm.hideDropOverlay();
		}

		this.removeClass("hover");

		event.preventDefault();
	}, false);


	listItem._element.addEventListener("drop", function(event) {
		// 先去掉hover的样式
		this.removeClass("hover");

		var dt = event.dataTransfer;
		var id = dt.getData("text/plain");
		id = id.indexOf(bmm.dragPrefix) !== -1 ? id.replace(bmm.dragPrefix, '') : id;

		var dropitem = this.listitem;

		// 加入‘未备份到网络的收藏’内容的处理
		if (dropitem.offline) {
			dt.dropEffect = 'none';
			bmm.hideDropOverlay();
			event.preventDefault();
			return false;
		}

		var index = dropitem.index;

		if (this.id === id) { // 如果是相同的一个listitem不作任何处理
			bmm.hideDropOverlay();
			event.preventDefault();
			return false;
		}
		//var dropitem = this.listitem;
		if (bmm.overlayType === "on") { // 放置到该listItem中
			if (this.className === "url") {
				bmm.hideDropOverlay();
				event.preventDefault();
				return false;
			} else {
				bmm.dropMove(id, this.id, 0);
			}
		} else if (bmm.overlayType === "above") { // 放置到该listItem之上
			bmm.dropMove(id, bmm.curTreeID, index);
		} else if (bmm.overlayType === "below") { // 放置到该listeItem之下
			++index;
			bmm.dropMove(id, bmm.curTreeID, index);
		} else { // 错误处理
			return false;
		}

		// 还原该标识
		bmm.overlayType = null;
		bmm.hideDropOverlay();

		event.preventDefault();
		event.stopPropagation();
	}, false);

	listItem._root = bmm.curTreeItem;

	return listItem;
};

bmm.dropMove = function(srcId, destId, index) {
	var id = srcId;
	var itemsChosedCount = 0;
	for (var id in itemsChosed) {
		itemsChosedCount++;
		qqbrowser.bookmark.move(parseInt(id), parseInt(destId), index, function(result) {
			var moveCode = JSON.parse(result)[0];

			if (moveCode === 1) {

			} else {
				alert("同名文件夹已存在，操作失败");
			}
		});
	}

	if (itemsChosedCount === 0) {
		qqbrowser.bookmark.move(parseInt(id), parseInt(destId), index, function(result) {
			var moveCode = JSON.parse(result)[0];

			if (moveCode === 1) {

			} else {
				alert("同名文件夹已存在，操作失败");
			}
		});
	}
};

/**
 * 刷新内容区域的内容展示
 */
bmm.flushList = function(curTreeID) {

	// 清除搜索标识位
	if (bmm.isSearch) {
		delete bmm.isSearch;
		getId('newFolder').removeClass('disabled');
		getId('sortByTitle').removeClass('disabled');
	}

	// 解决数据格式不一致的问题
	if (typeof curTreeID !== 'string')
		curTreeID = curTreeID.toString();

	// 每次重新刷新内容区数据时都需要清空itemsChosed结构
	// 因为内容区数据的更新导致刚才多选的数据已经没有用了
	bmm.curListID = null;
	bmm.curListItem = null;
	itemsChosed = {};
	curListIDChange();

	//console.info("curTreeID:", curTreeID);

	if (bmm.leadListItem) {
		// 可以不需要此操作，因为前面会移除一次dom树
		bmm.leadListItem.setLead(false);
		bmm.leadListID = null;
		bmm.leadListItem = null;
	}

	var isOffline = true;

	// 如果是未备份的数据，那么调用offline接口
	if (curTreeID.indexOf('offline-') !== -1) {
		curTreeID = curTreeID.replace('offline-', '');
		dataSource.getOfflineBookmarks(parseInt(curTreeID), buildLists);
		// 如果是原本的收藏收藏，那么调用getChildren接口
	} else {
		isOffline = false;
		dataSource.getChildren(parseInt(curTreeID), buildLists);
	}
	
	// 解决选中未备份收藏时，内容区操作按钮的状态
	if (isOffline) {
		bmm.isOffline = true;
		getId('newFolder').addClass('disabled');
		getId('sortByTitle').addClass('disabled');
		getId('edit').addClass('disabled');
		getId('deleteButton').addClass('disabled');
	} else {
		delete bmm.isOffline;
		getId('newFolder').removeClass('disabled');
		getId('sortByTitle').removeClass('disabled');
	}
	

	// 构建右侧内容区的listitems
	function buildLists(bookmark) {
		// 清空内容区的原有数据
		bmm.list._element.innerHTML = '';

		for (var i = 0, thisResult; thisResult = bookmark[i]; i++) {
			var id = isOffline ? 'offline-' + thisResult.id : thisResult.id;
			var listItem = bmm.buildListItem(id, thisResult.title, thisResult.type, thisResult.url, thisResult.faviconPath);
			listItem.parentId = thisResult.parentId;
			listItem.setDraggable(!isOffline);
			listItem.setOffline(isOffline);

			// 解决内容区新建文件夹后，该ListItem因为数据重新刷新而选中的问题
			if (bmm.newChosedItemID && thisResult.id == bmm.newChosedItemID) {
				listItem.setSelected(true);
				bmm.curListItem = listItem;
				bmm.curListID = listItem.id;
				bmm.newChosedItemID = null;
				// 重命名之后可以删除和编辑操作
				itemsChosed = {};
				itemsChosed[listItem.id] = listItem;
				curListIDChange();
			}

			listItem.index = i;
		}
	}

};

/**
 * 获取导航区树的根节点
 */
bmm.getRoot = function() {
	return getId("tree").firstChild;
};

/**
 * 获取导航区树的容器，相当于一个注册的过程
 */
bmm.getTreeContainer = function() {
	return getId("folder-tree");
};

/**
 * 用于按标题排序的功能
 */
bmm.sort = function(returnData) {
	var returnObject = JSON.parse(returnData);
	var unescapedData = unescape(returnObject[0]);
	var favObject = JSON.parse(unescapedData);
	var content = favObject;
	// 采取重新刷新的方式进行数据操作

	bmm.flushList(bmm.curTreeID);
};

bmm.checkSyncStatus = function() {
	// 未登录时不判断
	if (!bmm.isLogon || (!bmm.isSyncError && !bmm.isSyncLoading)) {
		return 1;
	}

	if(bmm.isSyncError) {
		// 显示同步错误提示
		//bmm.showSyncPopupDownloadTip();
	} else if(bmm.isSyncLoading) {
		// 显示同步提示
		//bmm.showSyncPopupDownloadEdit();
	}

	return 0;
};

/* 显示DownloadTip的同步对话框 */
bmm.showSyncPopupDownloadTip = function() {
	var oParent = {};
	oParent.type = "window";
	oParent.id = browser.window.currentId();

	// 应该需要重新定向dialog页面对应的位置
	qqbrowser.dialog.create(oParent, "aero\\notify.html?status=downloadTip", 336, 170, true, escape(''), true);
};

/* 显示DownloadEdit的同步对话框 */
bmm.showSyncPopupDownloadEdit = function() {
	var oParent = {};
	oParent.type = "window";
	oParent.id = browser.window.currentId();

	// 应该需要重新定向dialog页面对应的位置
	qqbrowser.dialog.create(oParent, "aero\\notify.html?status=downloadEdit", 336, 170, true, escape(''), true);
};

/**
 * 获取当前数据同步更新的状态
 * @param result 当前数据同步的状态值
 */
bmm.getSyncState = function(result) {

	var syncStateId = 0;
	if (typeof result === "string") {
		syncStateId = JSON.parse(result)[0];
	} else if (typeof result === "number"){
		syncStateId = result;
	} else {
		return;
	}

	if(syncStateId == 2) { // 异常时
		bmm.isSyncError = true;
		bmm.isSyncLoading = false;

		bmm.showSyncError();
		bmm.disableDrag();
	} else if(bmm.isRetry && syncStateId == 1) { // 异常时点击重试后下载时

		bmm.showSyncLoading();
		bmm.isSyncLoading = true;
	} else if(bmm.isRetry && syncStateId == 0) { // 异常时点击重试后成功时
		bmm.showSyncSuccess();
		bmm.enableDrag();

		bmm.isSyncLoading = false;
		bmm.isSyncError = false;
		bmm.isRetry = false;
	} else if(syncStateId == 1) { // 下载中
		bmm.showSyncLoading();

		bmm.isSyncLoading = true;
		bmm.isSyncError = false;

		bmm.disableDrag();
		bmm.hideSyncError();
	} else {
		bmm.isSyncError = false;
		bmm.isSyncLoading = false;

		bmm.hideSyncError();
		bmm.enableDrag();
	}
};

bmm.hBtnFuncBind = function() {
	var sortButton = getId("sortByTitle");
	var editButton = getId('edit');
	var deleteButton = getId("deleteButton");
	var newFolderButton = getId("newFolder");
	var loadMngButton = getId("loadMng");

	editButton.addEventListener('click', function() {
		if (bmm.isOffline) {
			return;
		}
		if (bmm.curListID) {
			if (event.button === 0) {
				if (bmm.curListItem.type === 'folder') {
					bmm.curListItem.setEditing(true);
				} else {
					var index = Array.prototype.indexOf.call(bmm.list._element.children, bmm.curListItem._element);
					if (index !== -1) {
						var command = {
							command: 'showEditFav',
							index: Number(index),/*在父文件夹中的索引*/
							bookmarkId: Number(bmm.curListItem.id),/*收藏URL的id*/
							title: bmm.curListItem.title,
							url: bmm.curListItem.url,
							favID: bmm.curListItem.parentId ? Number(bmm.curListItem.parentId) : /*收藏URL的父文件夹id*/
										Number(bmm.curTreeID)
						}
						qqbrowser.extension.sendRequest('{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}', command, function() {});
					}
				}
			}
		}
	}, false);

	sortButton.addEventListener("click", function(ev) {
		if (bmm.isSearch || bmm.isOffline) {
			return;
		}
		if (event.button === 0) {
			qqbrowser.extension.builtin.statistics.increase(STATIS_FAV_MANAGEPAGE_SORT);
			// 先隐藏右键菜单
			menuManager.contexMenu.hide();
			menuManager.newHandle.hide();
			menuManager.moreHandle.hide();

			if (event.button === 0) {
				if (!menuManager.sortHandle.visibility) { // 若菜单此时没有显示,那么显示
					// 跟菜单显示相关的操作
					menuManager.sortHandle.show("",ev);
					//menuManager.moreHandle.enable();
					menuManager.sortHandle._element.style.top = '26px';
					menuManager.sortHandle._element.style.left = 0;
				} else { // 若菜单此时已经显示，那么隐藏
					hideAllHeaderMenu();
				}
			}

			ev.preventDefault();
			event.stopPropagation();
			ev.returnValue = false;
			return false;
		}
	}, false);

	deleteButton.addEventListener("click", function() {
		if (bmm.isOffline) {
			return;
		}
		if (event.button === 0) {
			qqbrowser.extension.builtin.statistics.increase(STATIS_FAV_MANAGEPAGE_DELETE);
			bmm.deleteFunc();
		}}, false);

	newFolderButton.addEventListener("click", function(ev) {
		if (bmm.isSearch || bmm.isOffline) {
			return;
		}
		if (event.button === 0) {
			qqbrowser.extension.builtin.statistics.increase(STATIS_FAV_MANAGEPAGE_NEW_FOLDER);
			// 先隐藏右键菜单
			menuManager.contexMenu.hide();
			menuManager.sortHandle.hide();
			menuManager.moreHandle.hide();


			if (event.button === 0) {
				if (!menuManager.newHandle.visibility) { // 若菜单此时没有显示,那么显示
					// 跟菜单显示相关的操作
					menuManager.newHandle.show("",ev);
					//menuManager.moreHandle.enable();
					menuManager.newHandle._element.style.top = '26px';
					menuManager.newHandle._element.style.left = 0;
				} else { // 若菜单此时已经显示，那么隐藏
					hideAllHeaderMenu();
				}

			}

			ev.preventDefault();
			event.stopPropagation();
			ev.returnValue = false;
			return false;

		}
	}, false);

	// 管理菜单显示
	loadMngButton.addEventListener("click", function(ev) {
		// 先隐藏右键菜单
		menuManager.contexMenu.hide();
		menuManager.newHandle.hide();
		menuManager.sortHandle.hide();

		if (event.button === 0) {
			if (!menuManager.moreHandle.visibility) { // 若菜单此时没有显示,那么显示
				// 跟菜单显示相关的操作
				menuManager.moreHandle.show("",ev);

				menuManager.moreHandle._element.style.top = '26px';
				menuManager.moreHandle._element.style.left = 0;
			} else { // 若菜单此时已经显示，那么隐藏
				hideAllHeaderMenu();
			}

		}

		ev.preventDefault();
		event.stopPropagation();
		ev.returnValue = false;
		return false;

	}, false);
};

bmm.itemsChosedToClipBoard = function() {
	for (var id in itemsChosed) {
		if (clipBoard[id] === undefined) { // 进入剪切板的保护,已存在的话则不进入剪切板
			clipBoard[id] = itemsChosed[id];
		}
	}
	
	// Modified by littleli
	// 将选中板的内容复制到clipBoard之后，不需要
	/* 
	// 在完成数据转移后清空itemsChosed数组
	itemsChosed = {};
	curListIDChange();
	*/
};

bmm.newFolderFunc = function(type) {
	bmm.isChange = true;
	if (bmm.curTreeItem) {
		// Modified by littleli
		// 解决右侧选中文件夹项之后将新文件夹建立在选中文件夹中的问题
		if (bmm.curListItem && bmm.curListItem.type === 'folder' && type === 'content') {
			bmm.isChange = false;
			var title = bmm.namedFolder();
			qqbrowser.bookmark.create(parseInt(bmm.curListID), -1, title, "", function(returnData) {
				bmm.newChosedItemID = bmm.curListID;
			});
			return;
		}
		
		// 命名的函数接口也得做相应的调整
		var title = bmm.namedFolder('normal');
		
		qqbrowser.bookmark.create(parseInt(bmm.curTreeID), -1, title, "", function(returnData) {
			var returnObject = JSON.parse(returnData);
			var errorCode = returnObject[0];
			var newItemId = returnObject[1];

			var newItem = null;
			//alert(errorCode);
			//alert(newItemId);
			if (type === 'nav') {
				var newTreeItem = bmm.buildTreeItem(newItemId, bmm.curTreeItem, bmm.curTreeItem.layer + 1, title, false);

				if (newTreeItem !== bmm.curTreeItem) {
					bmm.curTreeItem.setSelected(false);
					bmm.curTreeItem.showSubTree();
					bmm.curTreeItem = newTreeItem;
					bmm.curTreeID = newTreeItem.id;
				}

				newItem = newTreeItem;
				newTreeItem.setSelected(true);
			} else {
						
				bmm.newChosedItemID = newItemId;

				var newListItem = bmm.buildListItem(newItemId, title, "folder", undefined, undefined, false);
				var newTreeItem = bmm.buildTreeItem(newItemId, bmm.curTreeItem, bmm.curTreeItem.layer + 1, title, false);

				// 建立内容区item与导航区item的关系
				newListItem.treeitem = newTreeItem;

				// 当前选中的导航区树节点不变，且展开
				bmm.curTreeItem.setSelected(true);
				bmm.curTreeItem.showSubTree();

				// 将内容区焦点置于新建的listItem中
				if (bmm.curListItem && bmm.curListItem !== newListItem) {
					bmm.curListItem.setSelected(false);
				}

				bmm.curListItem = newListItem;
				bmm.curListID = newListItem.id;

				newItem = newListItem;
				newListItem.setLead(true);
			}

			newItem.setSelected(true);
			newItem.setEditing(true);
		});
	}
};

bmm.pasteFunc = function(index, menuType) {
	var curItem;
	// 解决区分不同区域的粘贴问题
	if (menuType === 'nav') {
		curItem = bmm.curTreeItem;
	} else {
		if (bmm.curListItem && bmm.curListItem.type === 'folder') {
			curItem = bmm.curListItem;
		} else {
			curItem = bmm.curTreeItem;
		}
		
	}
	
	if (curItem) {
		var type = clipBoardFlag;
		// 操作类型映射具体的调用函数
		var typeToFunc = {
			2: 'copy',
			1: 'move'
		};

		for (var id in clipBoard) {
			qqbrowser.bookmark[typeToFunc[type]](parseInt(id), parseInt(curItem.id),
				(type === 1 ? index : 0), function(result) {
					var copyCode = JSON.parse(result)[0];
					if (copyCode === 1) {
					} else { // 如果在同一文件夹下进行复制进行相应的错误处理
						alert("同名文件或文件夹已存在，粘贴失败");
					}
				});
		}
		// 剪切完成后清空剪切板
		clipBoard = type === 1 ? {} : clipBoard;
	}
};

/**
 * 菜单功能绑定
 */
bmm.menuFuncBind = function(command) {

	function open(type) {
		var typeToFunc = {
			cur:
			{
				folder: 'openFolderCurWindow',
				url: 'openUrlCurWindow'
			},
			'new':
			{
				folder: 'openFolderNewWindow',
				url: 'openUrlNewWindow'
			}
		};

		if (bmm.menuType === 'nav') {
			qqbrowser.bookmark[typeToFunc[type]['folder']](parseInt(bmm.curTreeID));
		} else if (bmm.menuType === 'content') {
			if (itemsChosed[bmm.curListItem.id] === undefined) {
				itemsChosed[bmm.curListItem.id] = bmm.curListItem;
			}
			for (var id in itemsChosed) {
				if (itemsChosed[id].type === "folder") {
					qqbrowser.bookmark[typeToFunc[type]['folder']](parseInt(itemsChosed[id].id));
				} else {
					qqbrowser.bookmark[typeToFunc[type]['url']](itemsChosed[id].url, parseInt(itemsChosed[id].id));
				}
			}
		} else {
			return;
		}

	};

	bmm.openAll = function() {
		open('cur');
	};

	bmm.openAllInNewWindow = function() {
		open('new');
	};

	bmm.rename = function() {
		if (bmm.menuType === "nav") {

			bmm.curTreeItem.setEditing(true);

		} else if(bmm.menuType = "content") {
			// Modified by littleli
			// 区分url和folder不同的功能
			if (bmm.curListItem.type === 'folder') {
				bmm.curListItem.setEditing(true);
			} else {
				var index = Array.prototype.indexOf.call(bmm.list._element.children, bmm.curListItem._element);
				if (index !== -1) {
					var command = {
						command: 'showEditFav',
						index: Number(index),/*在父文件夹中的索引*/
						bookmarkId: Number(bmm.curListItem.id),/*收藏URL的id*/
						title: bmm.curListItem.title,
						url: bmm.curListItem.url,
						favID: bmm.curListItem.parentId ? Number(bmm.curListItem.parentId) : /*收藏URL的父文件夹id*/
									Number(bmm.curTreeID)
					}
					qqbrowser.extension.sendRequest('{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}', command, function() {});
				}
			}
		} else {
			return;
		}
	};

	bmm.cut = function() {
		if (bmm.isOffline)
			return;
		// 清空原来的剪切板的内容
		clipBoard = {};
		clipBoardFlag = 1;
		if (bmm.menuType === "nav") {
			if (bmm.curTreeItem) {
				if (clipBoard[bmm.curTreeItem.id] === undefined) {
					bmm.curTreeItem.addClass("cutting");
					clipBoard[bmm.curTreeItem.id] = bmm.curTreeItem;
				}
			}
		} else if(bmm.menuType = "content") {
			if (bmm.curListItem) {
				bmm.itemsChosedToClipBoard();
				if (clipBoard[bmm.curListItem.id] === undefined ){
					clipBoard[bmm.curListItem.id] = bmm.curListItem;
				}
			}
		} else {
			return;
		}
	};

	bmm.copy = function() {
		if (bmm.isOffline)
			return;
		// 清空原来的剪切板的内容
		clipBoard = {};
		clipBoardFlag = 2;
		if (bmm.menuType === "nav") {
			if (bmm.curTreeItem) {
				if (clipBoard[bmm.curTreeItem.id] === undefined) { // 如果剪切板中已经存在该项，不再进行保存
					clipBoard[bmm.curTreeItem.id] = bmm.curTreeItem;
				}
			}
		} else if(bmm.menuType = "content") {
			if (bmm.curListItem) {
				bmm.itemsChosedToClipBoard();
				if (clipBoard[bmm.curListItem.id] === undefined ){
					clipBoard[bmm.curListItem.id] = bmm.curListItem;
				}
			}
		} else {
			return;
		}
	};

	bmm.paste = function() {
		if (bmm.menuType === "nav") {
			bmm.pasteFunc(0, 'nav');
		} else if(bmm.menuType === "content") {
			if (bmm.curListItem) {
				// 粘贴对象为文件夹
				if (bmm.curListItem.type === "folder") {
					// 复制处理
					bmm.pasteFunc(0, 'content');
					// 粘贴的目标对象为url链接时的处理逻辑
				} else {
					var index = 0;
					var listLength = bmm.list._element.children.length;

					for (var i = 0; i < listLength; ++i) {
						if (bmm.curListItem._element === bmm.list._element.children[i]) {
							index = parseInt(i, 10) + 1;
							break;
						}
					}
					bmm.pasteFunc(index, 'content');
				}
			}
			// 空白处的粘贴操作
		} else {
			bmm.pasteFunc(0, 'nav');
		}
	};

	bmm._delete = function() {
		if (bmm.menuType === "nav") {
			if (bmm.curTreeItem) {
				setTimeout(function() {
					var result = confirm("确定要删除选中的1个项目吗？");
					if (result) {
						qqbrowser.bookmark.removeTree(parseInt(bmm.curTreeID));


						if (bmm.curTreeItem._root) { // 如果删除的文件夹节点有父节点,那么将焦点设置到该父节点上
							bmm.curTreeItem = bmm.curTreeItem._root;
							bmm.curTreeID = bmm.curTreeItem.id;
						} else { // 如果删除的文件夹节点没有父节点,那么将焦点设置到根节点上
							// 全局变量的设置恢复
							bmm.curTreeID = null;
							bmm.curTreeItem = null;
						}
					}
				}, 10);
			}
		} else if(bmm.menuType = "content") {
			bmm.deleteFunc();
		} else {
			return;
		}
	};

	/**
	 * 添加收藏时不区分来自导航区还是内容区的显示
	 */
	bmm.addFav = function() {
		var favID = null;
		if (bmm.menuType === 'nav' || bmm.menuType === null) {
			if (bmm.curTreeItem) {
				favID = bmm.curTreeID;
			}
		} else {
			if (bmm.curListItem) {
				favID = bmm.curListID;
			} else {
				favID = bmm.curTreeID;
			}
		}

		var command = {
			command: 'showAddFav',
			'favID': parseInt(favID, 10),
			isNew: 1
		};
		qqbrowser.extension.sendRequest('{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}', command, function() {});
		menuManager.contexMenu.hide();
	};

	bmm.newFolder = function() {
		bmm.newFolderFunc(bmm.menuType);
	};

};

bmm.deleteFunc = function() {
	if (bmm.isOffline) 
		return;
	var itemsChosedCount = 0;

	for (var id in itemsChosed) {
		itemsChosedCount++;
	}

	if (itemsChosedCount === 0) {
		return;
	}
	setTimeout(function() {
		var result = confirm('确定要删除选中的' + itemsChosedCount + '个项目吗？');
		if (result) {
			for (var id in itemsChosed) {
				//itemsChosedCount++;
				if (itemsChosed[id].type === "folder") {
					if (itemsChosed[id].treeitem === bmm.curTreeItem) {
						bmm.curTreeID = null;
						bmm.curTreeItem = null;
					}
					qqbrowser.bookmark.removeTree(parseInt(itemsChosed[id].id), 10);
					//itemsChosed[id].treeitem.remove();
				} else {
					qqbrowser.bookmark.remove(parseInt(itemsChosed[id].id), 10);
				}
			}

			bmm.curListItem = null;
			bmm.curListID = null;
			itemsChosed = {};
			curListIDChange();
		}
	}, 10);	
};

bmm.renderUserMsg = function(userInfo){
	if (!!userInfo.nUin) {
		bmm.isLogon = true;
	}else{
	}
};

bmm.searchFuncBind = function() {
	var searchInput = getId("favorite_search");
	//	var searchButton = getId("search_icon");
	var searchClear = getId("search-clear");

	searchInput.addEventListener("keyup", function(event) {
		if (event.keyCode === 27) {
			this.value = "";
			bmm.search();
			this.blur();
			searchClear.addClass('find');
		} else {
			qqbrowser.extension.builtin.statistics.increase(STATIS_FAV_MANAGEPAGE_SEARCH);
			bmm.search();
		}
	},false);

	// 用input事件判断输入框关闭按钮的显示状态
	searchInput.addEventListener("input", function(event) {
		if (this.value !== "") {
			searchClear.removeClass('find');
		} else if (this.value === ""){
			searchClear.addClass('find');
		}
	},false);

	searchClear.addEventListener("click", function(event) {
		searchInput.value = "";
		searchClear.addClass('find');
		searchInput.focus();
		bmm.search();
	});

};

bmm.search = function() {
	var searchInput = getId("favorite_search").value;
	if (searchInput !== "") {
		//alert(searchInput);
		qqbrowser.bookmark.search(searchInput, function(returnData) {
			var returnObject = JSON.parse(returnData);
			var unescapedData = unescape(returnObject[0]);
			var favObject = JSON.parse(unescapedData);
			var content = favObject;

			bmm.isSearch = true;
			getId('newFolder').addClass('disabled');
			getId('sortByTitle').addClass('disabled');

			// 清空右侧内容区内容
			bmm.list._element.innerHTML = "";

			// 返回内容为空的时候进行相应的提示
			if(content.length === 0) {
				var searchEmpty = document.createElement('div');
				searchEmpty.setAttribute('id', 'search-empty');
				searchEmpty.innerHTML = '<span></span>' + '没有包含"' + searchInput + '"的收藏';
				bmm.list._element.appendChild(searchEmpty);

				// 不为空时生成新的内容区内容
			} else {
				for (var i = 0, thisResult; thisResult = content[i]; i++) {
					var listItem = bmm.buildListItem(thisResult.id, thisResult.title, thisResult.type, thisResult.url, thisResult.faviconPath);
					// 处理搜索结果，记录每条搜索结果来自的文件夹ID
					listItem.parentId = thisResult.parentId;
				}
			}
		});
	} else {
		bmm.flushList(bmm.curTreeID);
	}

};

/**
 * Shows and positions the drop marker overlay.
 * @param {ClientRect} targetRect The drop target rect
 * @param {string} overlayType The position relative to the target rect.
 * @private
 */
bmm.showDropOverlay = function(targetRect, overlayType) {
	window.clearTimeout(bmm.hideDropOverlayTimer);
	var overlay = getId('drop-overlay');
	if (overlayType == 'on') {
		overlay.className = '';
		overlay.style.top = targetRect.top + 'px';
		overlay.style.height = targetRect.height + 'px';
		overlay.style.display = "none";
	} else {
		overlay.className = 'line';
		overlay.style.height = '';
		overlay.style.display = 'block';
	}
	overlay.style.width = targetRect.width + 'px';
	overlay.style.left = targetRect.left + 'px';

	if (overlayType != 'on') {
		var overlayRect = overlay.getBoundingClientRect();
		if (overlayType == 'above') {
			overlay.style.top = targetRect.top - overlayRect.height / 2 + 'px';
		} else {
			overlay.style.top = targetRect.top + targetRect.height - overlayRect.height / 2 + 'px';
		}
	}
};

document.addEventListener('mouseup', function() {
	bmm.clearDragData();
	bmm.hideDropOverlay();
}, false);

document.addEventListener('dragend', function() {
	bmm.clearDragData();
	bmm.hideDropOverlay();
}, false);

/**
 * Hides the drop overlay element.
 * @private
 */
bmm.hideDropOverlay = function() {
	// Hide the overlay in a timeout to reduce flickering as we move between
	// valid drop targets.
	window.clearTimeout(bmm.hideDropOverlayTimer);
	bmm.hideDropOverlayTimer = window.setTimeout(function() {
		getId('drop-overlay').style.display = '';
	}, 100);
}

/**
 * 结束时清理拖拽数据
 */
bmm.clearDragData = function() {
	setTimeout(function() {
		bmm.dragData = {};
	})
}

bmm.dragScrollFuncBind = function(element) {
	var DRAGOVER_SCROLL_MARGIN = 30, SCROLL_PIXELS_PER_DRAGOVER = 20;

	function getOffsetTop(element)
	{
		var top = 0, ele = element;
		while(ele.offsetParent !== /*document.body*/ null)
		{
			top += ele.offsetTop;
			ele = ele.offsetParent;
		}

		return top;
	}
	var offsetTop = getOffsetTop(element);

	function dragoverScroll(event) {
		//console.log('over');
		var dt = event.dataTransfer;

		//dt.dropEffect = "move";
		event.preventDefault();
		event.stopPropagation();

		var currentTarget = event.currentTarget;
		if((currentTarget.offsetHeight + offsetTop) - event.pageY <= DRAGOVER_SCROLL_MARGIN) // 滚动条向下滚动
		{
			currentTarget.scrollTop += SCROLL_PIXELS_PER_DRAGOVER;
			//console.log('scroll down');
		}
		else if(event.pageY - offsetTop <= DRAGOVER_SCROLL_MARGIN) // 滚动条向上滚动
		{
			currentTarget.scrollTop -= SCROLL_PIXELS_PER_DRAGOVER;
			//console.log('scroll up');
		}
	}
	element.addEventListener('dragover', dragoverScroll, false);
};

/**
 * 新建文件夹时给该文件夹进行命名
 */
bmm.namedFolder = function(flagType) {
	var date = new Date();
	var month = (date.getMonth() + 1) > 9 ? (date.getMonth() + 1) : '0' + (date.getMonth() + 1);
	var newdate = (date.getDate()) > 9 ? (date.getDate()) : '0' + (date.getDate());
	var folderName = [date.getFullYear(), '-', month, '-', newdate].join("");
	var count = 0;
	var title = folderName;
	var flag = true;

	// 解决右侧内容区选中后其子文件夹命名重复的问题
	var curSubFolders = (flagType === 'normal')? bmm.curTreeItem._treeChildren.children :
							bmm.curListItem.treeitem._treeChildren.children;
							
	// 解决文件夹名称冲突的问题
	while(true) {
		flag = true;
		if (count !== 0) {
			title = [folderName, "(" , count , ")"].join("");
		}
		for (var i = 0; i < curSubFolders.length; i++) {
			var treeitem = curSubFolders[i].treeitem;
			if (treeitem && title === treeitem.title) {
				flag = false;
				break;
			}
		}
		if (flag) {break;}
		count++;
	}

	return title;
}

bmm.init();
